/////////////////////////////////////////////////////////////////////////////
//
//	File: QzTest.h
//
//	$Header: /Projects/QzTest/QzTest.h  3  2009/9/14 5:45:53p  Lee $
//
/////////////////////////////////////////////////////////////////////////////


#pragma once


#include "QzClient.h"
#include "TestThread.h"


class QzTest
	:	public QzClient
{
private:
	S32			m_MouseX;
	S32			m_MouseY;
	bool		m_MouseLeftDown;
	bool		m_CtrlDown;

	bool		m_MouseLocked;
	S32			m_LockedX;
	S32			m_LockedY;

	bool		m_Paused;
	U32			m_TimeStamp;
	U32			m_ObjectCount;

	TestThread	m_Thread;

public:
	QzTest(void);
	~QzTest(void);

	virtual void GetAppTitle(Utf08_t buffer[], U32 bufferSize);
	virtual U32  GetMaxFrameDelay(void);
	virtual void KeyPress(U32 keyFlags, U32 key);
	virtual void KeyChar(Utf32_t keyChar);
	virtual void MouseMove(S32 x, S32 y);
	virtual void MouseDelta(S32 dx, S32 dy);
	virtual void MouseClick(QzMouseButton_t button, QzMouseClick_t click, U32 flags, S32 x, S32 y);
	virtual void MouseWheel(S32 delta);
	virtual void Render(QzRenderer *pRenderer);
};


