/////////////////////////////////////////////////////////////////////////////
//
//	File: QzLogUtil.h
//
//	$Header: /Projects/QzLogUtilWin/QzLogUtil.cpp  1  2009/9/9 9:43:48a  Lee $
//
/////////////////////////////////////////////////////////////////////////////


#define VC_EXTRALEAN		// Exclude rarely-used stuff from Windows headers

#define _WIN32_WINNT 0x0501

#include <afxwin.h>         // MFC core and standard components
#include <afxext.h>         // MFC extensions
#include <afxdtctl.h>		// MFC support for Internet Explorer 4 Common Controls
#include "QzLogUtil.h"
#include "QzLogUtilDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CQzLogUtilApp

BEGIN_MESSAGE_MAP(CQzLogUtilApp, CWinApp)
	//{{AFX_MSG_MAP(CQzLogUtilApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CQzLogUtilApp construction

CQzLogUtilApp::CQzLogUtilApp()
{
}


/////////////////////////////////////////////////////////////////////////////
// The one and only CQzLogUtilApp object

CQzLogUtilApp theApp;


/////////////////////////////////////////////////////////////////////////////
// CQzLogUtilApp initialization

BOOL CQzLogUtilApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
//	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
//	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	SetRegistryKey(L"TeachSolaisGames");

	CQzLogUtilDlg dialog;
	dialog.m_XCoord			= GetProfileInt(L"Logging", L"xCoord", 0);
	dialog.m_YCoord			= GetProfileInt(L"Logging", L"yCoord", 0);
	dialog.m_EnableLogging	= GetProfileInt(L"Logging", L"enable", 1);

	CString name = GetProfileString(L"Logging", L"filename", L"C:\\QzLog.txt");
	wcscpy(dialog.m_FileName, name);

	m_pMainWnd = &dialog;
	dialog.DoModal();

	WriteProfileInt(L"Logging", L"xCoord", dialog.m_XCoord);
	WriteProfileInt(L"Logging", L"yCoord", dialog.m_YCoord);
	WriteProfileInt(L"Logging", L"enable", dialog.m_EnableLogging);
	WriteProfileString(L"Logging", L"filename", dialog.m_FileName);

	// Since the dialog has been closed, return FALSE so that we exit the
	// application, rather than start the application's message pump.
	return FALSE;
}

