/////////////////////////////////////////////////////////////////////////////
//
//	File: QzTxtReader.h
//
//	$Header: /TS/TsFile/QzTxtReader.h  6  2009/9/7 3:18:16p  Lee $
//
//
//	Utility class for reading a text file.  This will convert the file into
//	UTF-8 format and compose the text to merge diacritics with their base
//	symbols.  This can recognize ASCII, UTF-8, UTF-16 BE, UTF-16 LE, and
//	UTF-32.  It will read the whole file into memory and compose it in one
//	pass, so all read operations are directly from memory.
//
/////////////////////////////////////////////////////////////////////////////


#pragma once


class QzTxtReader
{
private:
	U32      m_ByteOffset;
	U32      m_ByteCount;		// this does not count extra '\0' at end of buffer
	Utf08_t* m_pBuffer;

public:
	QzTxtReader(void);
	~QzTxtReader(void);

	bool LoadFile(const Utf08_t filename[]);

	S32  ReadLine(Utf08_t pDst[], U32 dstLimit);

	Utf08_t* ExtractBuffer(U32 &byteCount);

	bool IsOpen(void)			{ return (NULL != m_pBuffer); }
	U32  ByteCount(void)		{ return m_ByteCount; }
	U08* Address(void)			{ return m_pBuffer; }
};


