/////////////////////////////////////////////////////////////////////////////
//
//	File: QzRenderer.h
//
//	$Header: /Projects/Qz/QzRenderer.h  2  2009/9/14 1:39:30p  Lee $
//
//
//	Abstracts rendering behind a class definition.  This keeps all of the
//	platform-specific differences (Windows vs. OS X) in a single place,
//	so that porting to a new platform only requires changing the contents of
//	the CPP file.  It also prevents any other source code from needing to
//	include any platform-specific header files in the rest of the project,
//	protecting the code from any non-standard header behavior (especially
//	the profusion of UNICODE #defines in windows.h).
//
//	This class is very minimalist, with just a little OpenGL used for simple
//	rendering.  I don't use OpenGL's coordinate system, since I normally
//	write code that supports rendering by both OpenGL and DirectX, depending
//	on the current platform.  None of that code is used here (it would be
//	overkill for this app), but I keep to my usual coordinate math to avoid
//	introducing confusion for myself.
//
/////////////////////////////////////////////////////////////////////////////


#pragma once


#include "QzFontHandler.h"


class QzRenderer
{
private:
	S32  m_WindowWidth;
	S32  m_WindowHeight;
	bool m_IsCreated;

	QzFontHandler	m_Fonts;
	QzTexture*		m_pFontTexture;

public:
	QzRenderer(void);
	~QzRenderer(void);

	void LogExtensions(void);
	void Create(void);
	void Destroy(void);
	bool LoadFonts(const Utf08_t filename[]);
	bool IsCreated(void);

	void SetResolution(U32 width, U32 height);
	void PrepareParallel(void);
	void ClearFrameBuffer(void);
	void RenderFinish(void);
	void DrawPolygon(QzVector_t verts[], U32 pointCount);
	void DrawLineList(QzVector_t verts[], U32 lineCount);
	void DrawPointList(QzVector_t verts[], U32 pointCount);
	void FontRender(U32 fontID, S32 x, S32 y, const Utf08_t strg[]);
	U32  TextureBind(QzTexture *pTexture);
	void TextureUnbind(QzTexture *pTexture);

	S32  GetWidth(void)		{ return m_WindowWidth; }
	S32  GetHeight(void)	{ return m_WindowHeight; }
};


