/////////////////////////////////////////////////////////////////////////////
//
//	File: QzRectSorter.h
//
//	$Header: /TS/TsGui/QzRectSorter.h  5  2009/9/8 12:43:20a  Lee $
//
//
//	This is a utility class used to pack sub-rectangles into a larger area.
//	It is used to pack individual lightmaps, textures, and font glyphs into
//	a larger buffer, assuring that each rectanle is assigned a unique region
//	of space so no two rectangles overlap.
//
/////////////////////////////////////////////////////////////////////////////


#pragma once


#include "QzArray.h"


class QzRectSorter;


/////////////////////////////////////////////////////////////////////////////
//
struct QzRectSortPosition_t
{
	U32				Left;
	U32				Top;
	U32				Width;
	U32				Height;
	QzRectSorter*	pSort;
	void*			pContext;
};


typedef QzArray<QzRectSortPosition_t> QzRectSortPosList_t;


/////////////////////////////////////////////////////////////////////////////
//
class QzRectSorter
{
public:
	QzRectSorter*			m_pLeft;
	QzRectSorter*			m_pRight;
	QzRectSortPosition_t	m_Position;

	/////////////////////////////////////////////////////////////////////////

	QzRectSorter(void);
	~QzRectSorter(void);

	void  Initialize(U32 width, U32 height);

	QzRectSorter* Insert(const QzRectSortPosition_t &position);
};

