/////////////////////////////////////////////////////////////////////////////
//
//	File: QzMatrix3x3.h
//
//	$Header: /TS/TsGui/QzMatrix3x3.h  2  2009/9/8 4:11:52p  Lee $
//
/////////////////////////////////////////////////////////////////////////////


#pragma once


#include "QzVector.h"


class QzQuat;


class QzMatrix3x3
{
public:
	QzMatrix3x3_t m_Matrix;

public:
	bool IsIdentity(void);

	void MakeZero(void)				{ SafeZeroVar(m_Matrix); }
	void MakeIdentity(void);
	void MakeRotateX(float angle);
	void MakeRotateY(float angle);
	void MakeRotateZ(float angle);
	void MakeRotateArbitraryAxis(float x, float y, float z, float angle);
	void MakeRotateArbitraryAxis(const QzVector vec, float angle) { MakeRotateArbitraryAxis(vec.m_X, vec.m_Y, vec.m_Z, angle); }
	void MakeScale(QzVector vec);
	void MakeScale(float factor);

	void TensorConeX(float mass, float height, float radius);
	void TensorConeY(float mass, float height, float radius);
	void TensorConeZ(float mass, float height, float radius);
	void TensorCuboid(float mass, float x, float y, float z);
	void TensorCylinderX(float mass, float height, float radius);
	void TensorCylinderY(float mass, float height, float radius);
	void TensorCylinderZ(float mass, float height, float radius);
	void TensorSphere(float mass, float radius);

	void PreRotateX(float angle);
	void PostRotateX(float angle);
	void PreRotateY(float angle);
	void PostRotateY(float angle);
	void PreRotateZ(float angle);
	void PostRotateZ(float angle);
	void PreRotate(QzQuat &quat);
	void PostRotate(QzQuat &quat);
	void PreScale(float x, float y, float z);
	void PreScale(float x);
	void PostScale(float x, float y, float z);
	void PostScale(float x);

	void PreTripleRotate(const QzVector rotate);

	void ComputeInverseMatrix(QzMatrix3x3 &src);
	void ComputeNormalMatrix(QzMatrix3x3 &src);

	void Multiply(const QzMatrix3x3 &first, const QzMatrix3x3 &second);
	void PreMultiply(const QzMatrix3x3 &first);
	void PostMultiply(const QzMatrix3x3 &second);
	void TransformVector(const QzVector vec, QzVector &result);
	void TransformVector(const QzVector_t vec, QzVector_t &result);
	void Transpose(void);
	void LeftHandedToRightHanded(const QzMatrix3x3 &src);

	void LogMatrix(void);
	void PrintMatrix(void);
};



