/////////////////////////////////////////////////////////////////////////////
//
//	File: QzInterface.h
//
//	$Header: /Projects/Qz/QzInterface.h  2  2009/9/14 1:30:35p  Lee $
//
//
//	Abstract interface used by the client and most internal classes to
//	communicate with the manager object.  This avoids needing to include
//	the full manager header in every single source file.
//
/////////////////////////////////////////////////////////////////////////////


#pragma once


class QzInterface
{
public:
	virtual U32  GetFrameDuration(void) = 0;
	virtual U32  GetKeyState(U32 key) = 0;
	virtual bool IsMouseExclusive(void) = 0;
	virtual void RequestAppTermination(void) = 0;
	virtual void SetMouseExclusive(bool exclusive) = 0;
	virtual void ClearDirtyFlag(void) = 0;
	virtual void SetDirtyFlag(void) = 0;
};


extern QzInterface* g_pQzInterface;


