//////////////////////////////////////////////////////////////////////////////
//
//	File: QzFile.h
//
//	$Header: /TS/TsFile/QzFile.h  13  2009/9/9 4:16:02p  Lee $
//
//
//	Simple wrapper class around FILE routines to simplify read/write calls,
//	and project against files not being closed.
//
//////////////////////////////////////////////////////////////////////////////


#pragma once


class QzFile
{
private:
	bool	m_Writeable;
	FILE*	m_pFile;

public:
	QzFile(void);
	~QzFile(void);

	bool  CreateNew(const Utf08_t filename[]);
	bool  OpenExisting(const Utf08_t filename[]);
	void  Close(void);

	bool  ReadData(void *pData, U32 byteCount);
	bool  WriteData(void *pData, U32 byteCount);

	bool  Seek(U32 offset);
	bool  SeekToEnd(void);

	U32   Position(void);
	U32   Size(void);

	bool IsOpen(void)
	{
		return (NULL != m_pFile);
	}
};


