/////////////////////////////////////////////////////////////////////////////
//
//	File: QzClient.h
//
//	$Header: /Projects/Qz/QzClient.h  3  2009/9/14 5:44:08p  Lee $
//
//
//	The app needs to implement a client object that handles all of the
//	app-specific functionality.  This object will be instanced during
//	initialization by calling the InstanceQzClient() function.  The client
//	object must inherit from QzClient and implement all of the virtual
//	functions defined in this interface.
//
/////////////////////////////////////////////////////////////////////////////


#pragma once


class QzRenderer;


class QzClient
{
public:
	// QzClient's destructor must be virtual, otherwise the destructor for
	// the class inheriting from QzClient will not be called.
	virtual ~QzClient(void) {}

	virtual void GetAppTitle(Utf08_t buffer[], U32 bufferSize) = 0;
	virtual U32  GetMaxFrameDelay(void) = 0;
	virtual void KeyPress(U32 keyFlags, U32 key) = 0;
	virtual void KeyChar(Utf32_t keyChar) = 0;
	virtual void MouseMove(S32 x, S32 y) = 0;
	virtual void MouseDelta(S32 dx, S32 dy) = 0;
	virtual void MouseClick(QzMouseButton_t button, QzMouseClick_t click, U32 flags, S32 x, S32 y) = 0;
	virtual void MouseWheel(S32 delta) = 0;
	virtual void Render(QzRenderer *pRenderer) = 0;
};


QzClient* InstanceQzClient(void);


