/////////////////////////////////////////////////////////////////////////////
//
//	File: QzByteStream.h
//
//	$Header: /TS/TsFile/QzByteStream.h  16  2009/9/14 2:14:42p  Lee $
//
//
//	Utility class for extracting data from a packed byte stream.  This will
//	enforce protection against buffer overruns, silently returning zeroes if
//	there is not enough data to fulfill any given request.  If there is an
//	overflow, this will set an internal flag to signal the problem.
//
/////////////////////////////////////////////////////////////////////////////


#pragma once


class QzQuat;
class QzVector;


class QzByteStream
{
private:
	U08* m_pData;
	U32  m_ByteCount;

	// This flag gets set if any method attempts to read past the end of the
	// byte buffer.
	bool m_Overflow;

public:
	QzByteStream(void);
	QzByteStream(U08 *pData, U32 byteCount);

	void  StartStream(U08 *pData, U32 byteCount);

	U08   PeekU08(void);
	U16   PeekU16(void);
	U32   PeekU32(void);
	void  SkipData(U32 byteCount);
	void  ReadArrayU08(U08 *pData, U32 valueCount);
	void  ReadArrayU16(U16 *pData, U32 valueCount);
	void  ReadArrayU32(U32 *pData, U32 valueCount);
	S32   ReadVarS32(void);
	U32   ReadVarU32(void);
	U08   ReadU08(void);
	U16   ReadU16(void);
	U16   ReadBeU16(void);
	U32   ReadU32(void);
	U32   ReadBeU32(void);
	U32   ReadFourCC(void);
	float ReadFloat(void);
	S16   ReadS16(void);
	S32   ReadS32(void);
	void  ReadQuaternion(QzQuat &quat);
	void  ReadVector(QzVector &vec);

	void  ReadString(Utf08_t *pBuffer, U32 bufferSize, U32 readSize);
	void  ReadString8(Utf08_t *pBuffer, U32 maxLength);
	void  ReadString16(Utf08_t *pBuffer, U32 maxLength);

	Utf08_t* AllocString8(void);
	Utf08_t* AllocString16(void);

	bool  ChunkCleanup(void);

	U32   ComputeCRC(U32 byteCount);

	U32   ByteCount(void)	{ return m_ByteCount; }
	bool  Overflow(void)	{ return m_Overflow; }
	U08*  Address(void)		{ return m_pData; }
};


