/////////////////////////////////////////////////////////////////////////////
//
//	File: QzBuffer.h
//
//	$Header: /Projects/Qz/QzBuffer.h  10  2009/9/7 1:42:06p  Lee $
//
//
//	A simple utility class used to allocate and automatically free buffers
//	when going out of scope.
//
/////////////////////////////////////////////////////////////////////////////


#pragma once


class QzBuffer
{
private:
	U08* m_pBuffer;
	U32  m_Size;

public:

	QzBuffer(void)
		:	m_pBuffer(NULL),
			m_Size(0)
	{
	}

	QzBuffer(U32 size)
		:	m_pBuffer(NULL),
			m_Size(0)
	{
		Allocate(size);
	}

	~QzBuffer(void)
	{
		Free();
	}

	U08* Allocate(U32 size);
	void Copy(U08 *pData, U32 size);
	void Copy(QzBuffer &src);
	void Assign(QzBuffer &src);
	void Assign(U08 *pData, U32 byteCount);
	U08* Extract(void);
	void Resize(U32 size);
	void Truncate(U32 size);
	void Free(void);

	bool ReadFromFile(const Utf08_t filename[]);
	void WriteToFile(const Utf08_t filename[]);

	U08* GetAddress(void)
	{
		return m_pBuffer;
	}

	U32 GetSize(void)
	{
		return U32(m_Size);
	}
};


